Imports System.Text
Imports ComponentPro

Namespace AdvancedDemo.Samples.Template_and_Template_Class
	Friend Class Getting_Template_Reference
		Inherits TemplateExampleBase
		''' <summary>
		''' Generates output from a template file.
		''' </summary>
		''' <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
		''' <param name="templateFile">The template file path.</param>
		''' <param name="templateSource">The template source loaded from the template file.</param>
		''' <returns>The generated output.</returns>
		Public Overrides Function Generate(ByVal templateSourceDirectory As String, ByVal templateFile As String, ByVal templateSource As String) As String
			Dim gen As New StringBuilder()

			' Create a new instance of the TemplateEngine class.
			Dim dt As New TemplateEngine()

			dt.LoadTemplateClassesFromFile(templateSourceDirectory & "\Sample.tpc")
			dt.LoadFromString(templateSource)

			dt.SetValue("a", 100)
			dt.SetValue("b", 2)
			dt.SetValue("c", 1)
			dt.SetValue("d", 8)

			' Find template "mytemplate" inside "myclass" and render it.
			Dim tpl1 As Template = dt.FindTemplate("global::myclass.mytemplate")
			Dim output As String = dt.Run(tpl1)
			gen.Append(output)
			' Find child template "child1" of "mytemplate" inside "myclass" and render it.
			Dim tpl2 As Template = dt.FindTemplate("global::myclass.mytemplate.child1")
			output = dt.Run(tpl2)
			gen.Append(output)
			' Find child template "child2" defined in Template.tpl and render it.
			Dim tpl3 As Template = dt.FindTemplate("child2")
			output = dt.Run(tpl3)
			gen.Append(output)
			' Render the mainly loaded template.
			output = dt.Run()
			gen.Append(output)

			Return gen.ToString()
		End Function
	End Class
End Namespace
